require("dotenv").config();
const express = require("express");
const cors = require("cors");
const path = require("path");
const db = require("./db");

const app = express();

app.use(cors());
app.use(express.json());

// Serve frontend
app.use(express.static(path.join(__dirname, "../public")));

app.get("/", (req, res) => {
  res.sendFile(path.join(__dirname, "../public/index.html"));
});

// Contact API
app.post("/api/contact", async (req, res) => {
  console.log("📩 Incoming data:", req.body);

  try {
    const { name, email, phone, subject, message, newsletter } = req.body;

    if (!name || !email || !message) {
      return res.status(400).json({ success: false, message: "Required fields missing" });
    }

    await db.execute(
      `INSERT INTO contact_messages 
       (full_name, email, phone, subject, message, newsletter, ip_address)
       VALUES (?, ?, ?, ?, ?, ?, ?)`,
      [
        name,
        email,
        phone || null,
        subject || "general",
        message,
        newsletter ? 1 : 0,
        req.ip
      ]
    );

    res.json({ success: true, message: "Message sent successfully" });
  } catch (err) {
    console.error("❌ DB ERROR:", err);
    res.status(500).json({ success: false, message: "Server error" });
  }
});

app.listen(3000, () => {
  console.log("✅ Server running at http://localhost:3000");
});