const fs = require('fs');
const path = require('path');

console.log('🚀 Building Educate Maa Website...');

const distDir = './dist';
if (!fs.existsSync(distDir)) {
  fs.mkdirSync(distDir, { recursive: true });
  console.log('📁 Created dist directory');
}

const htmlFiles = ['index.html', 'work.html', 'about.html', 'impact.html', 'involve.html', 'contact.html'];
htmlFiles.forEach(file => {
  if (fs.existsSync(file)) {
    fs.copyFileSync(file, path.join(distDir, file));
    console.log(`✅ Copied ${file}`);
  }
});

const publicDirs = ['css', 'js', 'images'];
publicDirs.forEach(dir => {
  const dirPath = path.join(distDir, 'public', dir);
  if (!fs.existsSync(dirPath)) {
    fs.mkdirSync(dirPath, { recursive: true });
  }
});

console.log('🎉 Build completed successfully!');
console.log('📁 Output directory: ./dist');
console.log('👉 Run "npm run deploy" to create production build');